/*
 * @(#)AppletUtil.java  1.3  2003-07-25
 *
 * Copyright (c) 2000 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.util;

import java.applet.Applet;
import java.util.*;

/**
 * Usefull methods for applets.
 *
 * @author Werner Randelshofer
 * @version 1.3 2003-07-25 Method
 * getIndexedKeyValueParameters(Applet,String,Hashtable) added.
 * <br>1.2 2002-06-26 Method getParameter(Applet,String,double) added.
 * <br>1.1 2001-12-27 Method getParameters did not work.
 * <br>1.0 2000-03-06
 */
public class Applets extends Object {
    /**
     * Suppresses default constructor, ensuring non-instantiability.
     */
    private Applets() {
    }
    
    /**
     * Returns the String value of an applet parameter or the
     * default value if the parameter is null.
     *
     * @param   applet  The applet from which we want to get the parameter.
     * @param   name    The name of the parameter.
     * @param   defaultValue This value is returned when the applet returns
     *                  null for the parameter.
     */
    public static String getParameter(Applet applet, String name, String defaultValue) {
        String value = applet.getParameter(name);
        return value != null ? value : defaultValue;
    }
    
    /**
     * Returns the parameter value of the specified applet or the
     * default value if the parameter is null, the value is
     * returned as an array. The values of the array consist
     * of each word found in the value. The words are delimited
     * by spaces or by commas.
     *
     * @param   applet  The applet from which we want to get the parameter.
     * @param   name    The name of the parameter.
     * @param   defaultValue This value is returned when the applet returns
     *                  null for the parameter.
     */
    public static String[] getParameters(Applet applet, String name, String[] defaultValue) {
        String param = applet.getParameter(name);
        if (param != null) {
            StringTokenizer scanner = new StringTokenizer(param, ", ");
            String[] values = new String[scanner.countTokens()];
            for (int i = 0; i < values.length; i++) {
                values[i] = scanner.nextToken();
            }
            return values;
        }
        return defaultValue;
    }
    
    public static int getParameter(Applet applet, String name, int defaultValue) {
        String value = applet.getParameter(name);
        if (value != null) {
            try {
                //return Integer.parseInt(value);
                return decode(value).intValue();
            } catch (NumberFormatException e) {}
        }
        
        return defaultValue;
    }
    
    public static int[] getParameters(Applet applet, String name, int[] defaultValue) {
        String param = applet.getParameter(name);
        if (param != null) {
            try {
                StringTokenizer scanner = new StringTokenizer(param, ", ");
                int[] values = new int[scanner.countTokens()];
                for (int i = 0; i < values.length; i++) {
                    //values[i] = Integer.parseInt(scanner.nextToken());
                    values[i] = decode(scanner.nextToken()).intValue();
                }
                return values;
            } catch (NumberFormatException e) {}
        }
        return defaultValue;
    }
    
    public static double getParameter(Applet applet, String name, double defaultValue) {
        String value = applet.getParameter(name);
        if (value != null) {
            try {
                //return Integer.parseInt(value);
                return Double.valueOf(value).doubleValue();
            } catch (NumberFormatException e) {}
        }
        
        return defaultValue;
    }
    
    /**
     * Returns the parameter value of the specified applet or the
     * default value if the parameter is null, the value is
     * returned as a Hashtable.
     * <p>
     * The parameter value is parsed according to the following EBNF production:
     * <pre>
     * list ::= entry {"," entry}
     * entry ::= [key "="] value
     * key ::= String
     * value ::= String
     * </pre>
     * <p>
     * The returned Hashtable contains up to two key value pairs for each entry.
     * <br>If an entry does specify a key, it is put using the specified key into
     * the hashtable.
     * <br>For each entry a key is generated which denotes the index of the entry.
     * If the Hashtable does not contain an entry for the generated key. Then an
     * entry is put using the generated key as well.
     *
     * @param   applet  The applet from which we want to get the parameter.
     * @param   name    The name of the parameter.
     * @param   defaultValue This value is returned when the applet returns
     *                  null for the parameter.
     * @return  A hashtable containing a key value pair for each entry.
     */
    public static Hashtable getIndexedKeyValueParameters(Applet applet, String name, Hashtable defaultValue) {
        String entry, key, value, generatedKey;
        int pos;
        String param = applet.getParameter(name);
        if (param != null) {
            Hashtable map = new Hashtable();
            StringTokenizer scanner = new StringTokenizer(param, ", ");
            int count = scanner.countTokens();
            for (int i = 0; i < count; i++) {
                entry = scanner.nextToken();
                pos = entry.indexOf('=');
                if (pos < 1) {
                    key = null;
                    value = entry;
                } else {
                    key = entry.substring(0, pos);
                    value = entry.substring(pos + 1);
                }
                generatedKey = Integer.toString(i);
                if (key != null) {
                    map.put(key, value);
                }
                if (! map.contains(generatedKey)) {
                    map.put(generatedKey, value);
                }
            }
            return map;
        }
        return defaultValue;
    }
    
    /**
     * Decodes a <code>String</code> into an <code>Integer</code>.  Accepts
     * decimal, hexadecimal, and octal numbers, in the following formats:
     * <pre>
     *     [-]    <decimal constant>
     *     [-] 0x     <hex constant>
     *     [-] #      <hex constant>
     *     [-] 0    <octal constant>
     * </pre>
     *
     * The constant following an (optional) negative sign and/or "radix
     * specifier" is parsed as by the <code>Integer.parseInt</code> method
     * with the specified radix (10, 8 or 16).  This constant must be positive
     * or a NumberFormatException will result.  The result is made negative if
     * first character of the specified <code>String</code> is the negative
     * sign.  No whitespace characters are permitted in the
     * <code>String</code>.
     *
     * @param     nm the <code>String</code> to decode.
     * @return    the <code>Integer</code> represented by the specified string.
     * @exception NumberFormatException  if the <code>String</code> does not
     *            contain a parsable integer.
     * @see java.lang.Integer#parseInt(String, int)
     */
    public static Integer decode(String nm) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        Integer result;
        
        // Handle minus sign, if present
        if (nm.startsWith("-")) {
            negative = true;
            index++;
        }
        
        // Handle radix specifier, if present
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        }
        else if (nm.startsWith("#", index)) {
            index ++;
            radix = 16;
        }
        else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            index ++;
            radix = 8;
        }
        
        if (nm.startsWith("-", index))
            throw new NumberFormatException("Negative sign in wrong position");
        
        try {
            result = Integer.valueOf(nm.substring(index), radix);
            result = negative ? new Integer(-result.intValue()) : result;
        } catch (NumberFormatException e) {
            // If number is Integer.MIN_VALUE, we'll end up here. The next line
            // handles this case, and causes any genuine format error to be
            // rethrown.
            String constant = negative ? new String("-" + nm.substring(index))
            : nm.substring(index);
            result = Integer.valueOf(constant, radix);
        }
        return result;
    }
}
